@echo off
chcp 65001 >nul
title HP OfficeJet Pro 8210 프린터 설치 - 더조은렌탈
color 0A

:start
cls
echo ========================================
echo   HP OfficeJet Pro 8210 프린터 설치
echo ========================================
echo.

REM 관리자 권한 확인
NET SESSION >nul 2>&1
if %errorLevel% neq 0 (
    echo 관리자 권한이 필요합니다.
    powershell -Command "Start-Process cmd -ArgumentList '/c ""%~f0""' -Verb RunAs"
    timeout /t 2 >nul
    exit /b
)

echo 설치할 프린터를 선택하세요:
echo.
echo    [1] 193번 (192.168.40.193)
echo    [2] 195번 (192.168.40.195) 
echo    [3] 198번 (192.168.40.198)
echo    [4] 200번 (192.168.40.200)
echo    [5] 202번 (192.168.40.202)
echo    [6] 207번 (192.168.40.207)
echo    [0] 종료
echo.
set /p choice="번호 선택 (0-6): "

if "%choice%"=="0" (
    exit /b
)

if "%choice%"=="1" (
    set IP=192.168.40.193
    set NAME=193번
) else if "%choice%"=="2" (
    set IP=192.168.40.195
    set NAME=195번
) else if "%choice%"=="3" (
    set IP=192.168.40.198
    set NAME=198번
) else if "%choice%"=="4" (
    set IP=192.168.40.200
    set NAME=200번
) else if "%choice%"=="5" (
    set IP=192.168.40.202
    set NAME=202번
) else if "%choice%"=="6" (
    set IP=192.168.40.207
    set NAME=207번
) else (
    echo 잘못된 입력입니다.
    timeout /t 2 >nul
    goto start
)

set PORT=IP_%IP%
cls

echo ========================================
echo   더조은렌탈 / 2870.kr / 1644-2870
echo ========================================
echo.

echo 설치 정보:
echo 프린터 이름: %NAME%
echo IP 주소: %IP%
echo.
echo 3초 후 설치를 시작합니다...
timeout /t 3 >nul

echo.
echo [1/4] 기존 프린터 삭제 중...
echo.

REM 방법 1: 동일한 이름으로 삭제 시도
echo 방법 1: 동일한 이름 삭제 - %NAME%
wmic printer where "name='%NAME%'" delete >nul 2>&1
if errorlevel 1 (
    echo 동일한 이름의 프린터 없음
) else (
    echo ✓ 동일한 이름 프린터 삭제 완료
)

REM 방법 2: 포트 이름으로 삭제 시도
echo.
echo 방법 2: 동일한 포트 삭제 - %PORT%
wmic printer where "portname='%PORT%'" delete >nul 2>&1
if errorlevel 1 (
    echo 동일한 포트의 프린터 없음
) else (
    echo ✓ 동일한 포트 프린터 삭제 완료
)

REM 방법 3: IP 주소가 포함된 프린터 검색 및 삭제
echo.
echo 방법 3: IP 주소 검색 - %IP%
for /f "tokens=2 delims==" %%P in ('wmic printer get portname /value ^| findstr "%IP%"') do (
    set "FOUND_PORT=%%P"
    echo 발견: !FOUND_PORT!
    wmic printer where "portname='!FOUND_PORT!'" delete >nul 2>&1
    if errorlevel 1 (
        echo 삭제 실패: !FOUND_PORT!
    ) else (
        echo ✓ 삭제 완료: !FOUND_PORT!
    )
)

REM 방법 4: 프린터 서비스 재시작 (필요시)
echo.
echo 방법 4: 프린터 서비스 재시작...
net stop spooler >nul 2>&1
timeout /t 2 >nul
net start spooler >nul 2>&1
echo ✓ 프린터 서비스 재시작 완료

echo.
echo ✓ 기존 프린터 정리 완료
timeout /t 2 >nul

echo.
echo [2/4] O8210 폴더에서 드라이버 검색 중...
echo.

REM 현재 스크립트 경로 확인
set "SCRIPT_DIR=%~dp0"

REM O8210 폴더에서 MSI 파일 검색
if exist "%SCRIPT_DIR%O8210\" (
    echo ✓ O8210 폴더를 찾았습니다.
    
    REM MSI 파일 검색
    for %%F in ("%SCRIPT_DIR%O8210\*.msi") do (
        set "MSI_FILE=%%F"
        echo ✓ 드라이버 파일 찾음: %%~nxF
        goto found_driver
    )
    
    echo ⚠ O8210 폴더에 MSI 파일이 없습니다.
    echo.
    echo 드라이버 없이 계속 진행합니다...
    goto skip_driver
) else (
    echo ⚠ O8210 폴더를 찾을 수 없습니다.
    echo.
    echo 드라이버 없이 계속 진행합니다...
    goto skip_driver
)

:found_driver
echo.
echo 드라이버 설치 중... (대화상자 모드)
echo 설치 창이 완전히 닫힐 때까지 기다려주세요.
echo.
timeout /t 2 >nul

start /wait "" "%MSI_FILE%"
echo ✓ 드라이버 설치 완료
timeout /t 2 >nul
goto continue_install

:skip_driver
echo Windows 기본 드라이버를 사용합니다.
timeout /t 2 >nul

:continue_install
echo.
echo [3/4] TCP/IP 포트 생성 중...
cscript //nologo %windir%\System32\Printing_Admin_Scripts\ko-KR\prnport.vbs -a -r "%PORT%" -h %IP% -o raw -n 9100 >nul 2>&1
echo ✓ 포트 생성 완료
timeout /t 1 >nul

echo.
echo [4/4] 네트워크 프린터 추가 및 설정...

REM 드라이버 순서대로 시도
echo 드라이버 설치 시도 중...
rundll32 printui.dll,PrintUIEntry /if /b "%NAME%" /m "HP OfficeJet Pro 8210 PCL-6" /r "%PORT%" >nul 2>&1
if errorlevel 1 (
    rundll32 printui.dll,PrintUIEntry /if /b "%NAME%" /m "HP OfficeJet Pro 8210 Series PCL-6" /r "%PORT%" >nul 2>&1
)
if errorlevel 1 (
    rundll32 printui.dll,PrintUIEntry /if /b "%NAME%" /m "HP OfficeJet Pro 8200 PCL-6" /r "%PORT%" >nul 2>&1
)
if errorlevel 1 (
    rundll32 printui.dll,PrintUIEntry /if /b "%NAME%" /m "HP Universal Printing PCL 6" /r "%PORT%" >nul 2>&1
)

echo ✓ 프린터 추가 완료

echo.
echo 기본 프린터 설정 중...
REM 여러 방법으로 기본 프린터 설정 시도

REM 방법 1: printui.dll 사용
rundll32 printui.dll,PrintUIEntry /y /n "%NAME%" >nul 2>&1
if errorlevel 1 (
    REM 방법 2: wmic 사용
    wmic printer where "name='%NAME%'" call setdefaultprinter >nul 2>&1
    if errorlevel 1 (
        REM 방법 3: PowerShell 사용
        powershell -Command "& {Add-Type -AssemblyName System.Windows.Forms; $printers = [System.Windows.Forms.Printing.PrinterSettings]::InstalledPrinters; if($printers -contains '%NAME%') { (New-Object -ComObject WScript.Network).SetDefaultPrinter('%NAME%') } }" >nul 2>&1
    )
)

echo ✓ 기본 프린터 설정 완료

echo.
echo ========================================
echo 설치 완료!
echo ========================================
echo.
echo 설치 정보:
echo - 프린터 이름: %NAME%
echo - IP 주소: %IP%
echo - 포트: %PORT%
echo.
echo 장치 및 프린터 창을 엽니다...
start control printers
echo.
echo 설치가 완료되었습니다.
echo.
echo 1. 다른 프린터 설치하기
echo 2. 프로그램 종료하기
echo.
set /p final_choice="선택 (1 또는 2): "

if "%final_choice%"=="1" (
    goto start
) else (
    echo 프로그램을 종료합니다.
    timeout /t 2 >nul
    exit /b
)